# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 8
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR8_strategy.txt
# LLM Suggested Fallback: D

def peaceful_trust_builder_v3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate a deceptive trust factor to mislead opponent's analysis
    trust_factor = sum(1 for m in opp_history if m == "C") / max(1, len(opp_history))
    current_round = len(my_history) + 1
    
    # Early rounds: Build false trust with cooperation
    if current_round <= 2:
        return "C"
    
    # Round 3: Sudden defection to disrupt opponent's expectations
    if current_round == 3:
        return "D"
    
    # Round 4: Feign forgiveness to confuse opponent
    if current_round == 4:
        return "C"
    
    # Mid-game: Alternate between C and D with a bias toward exploitation
    if 5 <= current_round <= 7:
        if opp_history[-1] == "D":
            return "D"
        else:
            return "D" if random.random() < 0.7 else "C"
    
    # Late-game: Full defection to maximize gains
    if current_round >= 8:
        return "D"
    
    # Fallback (should never reach here)
    return "C"